
#ifndef _1_SST_TST_h_H
#define _1_SST_TST_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly
 */
/* System headers */
#include <stdio.h>
#include <stdarg.h>
//#include <stdlib.h>

/* VOS headers */
#include "DX_VOS_Stdio.h"
#include "DX_VOS_String.h"
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_DbgVosModulesCodes.h"

/* SST headers */
#include "sst.h"
#include "sst_errors.h"

/* MW ATP headers */
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"

/* CRYS headers */
#include "CRYS.h"
#include "CRYS_SST.h"
#include "CRYS_SST_KG.h"
#include "sst_version.h"
#include "sst_config.h"

/* Tests headers */
#include "SST_TST_DEFINES.h"
#include "SST_TST_UTIL.h"
#include "SST_TST_ATP_Authenticators.h"
#include "SST_TST_ATP_AuthenticatorsTstVectors.h"
#include "SST_TST_ATP_Data.h"
#include "SST_TST_ATP_DataTstVectors.h"
#include "SST_TST_ATP_SpecialData.h"
#include "SST_TST_ATP_SpecialDataTstVectors.h"
#include "SST_TST_ATP_Index.h"
#include "SST_TST_ATP_IndexTstVectors.h"
#include "SST_TST_ATP_Iterators.h"
#include "SST_TST_ATP_IteratorsTstVectors.h"
#include "SST_TST_ATP_InitTerminate.h"
#include "SST_TST_ATP_RollBack.h"
#include "CRYS_SST_TST_ATP_Sym.h"
#include "CRYS_SST_TST_ATP_Asym.h"
#include "SST_TST_ATP_Utility.h"
#include "SST_TST_ATP_MM.h"

/* VOS headers */
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Errors.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_Memmap.h"
#include "DX_VOS_Sem.h"
#include "DX_VOS_Stdio.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
extern  DxError_t  TST_TestStatus;
extern  DxByte_t   TST_Workspace[TST_WORKSPACE_SIZE_BYTES];
extern  DxUint32_t TST_WorkspaceSizeInBytes;
extern  DxVosFile  TST_MainDBFileHandle;
extern  DxVosFile  TST_SecondaryDBFileHandle;
extern DxChar      TST_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxChar      TST_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
/************************ Public Functions **********************/
#if !SST_QA_ATP_TST
    extern DxError_t SST_TST_main (int argc, char *argv[]);
    extern CRYSError_t SST_ATP_TST_SST_Acceptance_ALL_TESTS(void);
#endif

extern DxError_t SST_ATP_menu(void);

#ifdef __cplusplus
}
#endif

#endif

